﻿var Constantes = {
    Gestion: {
        Ventas: {
            FiltrarProductos: {
                Tipo: {
                    SIMPLE: 0
                },
                SubTipo: {
                    POR_NOMBRE: 1,
                    POR_CODIGO: 2
                }
            },
            TablaDetalles: {
                Columna: {
                    CANTIDAD: 'cantidad',
                    PRECIO_UNITARIO: 'precioUnitario',
                    SUB_TOTAL: 'subTotal',
                    TOTAL: 'total',
                    PORCENTAJE_DESCUENTO: 'porcentajeDescuento'
                }
            },
            Mensaje: {
                TÍTULO: 'Notificación',
                Transaccion: {
                    Crear: {
                        Cotizacion: {
                            Exito: {
                                TITULO: 'Cotización creada',
                                DESCRIPCION: 'Su número de cotización es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la cotización',
                                DESCRIPCION: 'Su cotización no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Pedido: {
                            Exito: {
                                TITULO: 'Pedido creado',
                                DESCRIPCION: 'Su número de pedido es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear el pedido',
                                DESCRIPCION: 'Su pedido no fue creado, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Boleta: {
                            Exito: {
                                TITULO: 'Boleta creada',
                                DESCRIPCION: 'Su número de boleta es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la boleta',
                                DESCRIPCION: 'Su boleta no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Factura: {
                            Exito: {
                                TITULO: 'Factura creada',
                                DESCRIPCION: 'Su número de factura es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la factura',
                                DESCRIPCION: 'Su factura no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaVenta: {
                            Exito: {
                                TITULO: 'Nota de venta creada',
                                DESCRIPCION: 'Su número de nota de venta es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la nota de venta',
                                DESCRIPCION: 'Su nota de venta no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaCredito: {
                            Exito: {
                                TITULO: 'Nota de crédito creada',
                                DESCRIPCION: 'Su número de nota de crédito es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la nota de crédito',
                                DESCRIPCION: 'Su nota de crédito no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaDebito: {
                            Exito: {
                                TITULO: 'Nota de débito creada',
                                DESCRIPCION: 'Su número de nota de débito es {0}.'
                            },
                            Fallido: {
                                TITULO: 'No se pudo crear la nota de débito',
                                DESCRIPCION: 'Su nota de débito no fue creada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        }
                    },
                    Editar: {
                        Cotizacion: {
                            Exito: {
                                TITULO: 'Cotización editada',
                                DESCRIPCION: 'Su cotización fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Cotización no editada',
                                DESCRIPCION: 'Su cotización no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Pedido: {
                            Exito: {
                                TITULO: 'Pedido editado',
                                DESCRIPCION: 'Su pedido fue editado correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Pedido no editado',
                                DESCRIPCION: 'Su pedido no fue editado, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Boleta: {
                            Exito: {
                                TITULO: 'Boleta editada',
                                DESCRIPCION: 'Su boleta fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Boleta no editada',
                                DESCRIPCION: 'Su boleta no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        Factura: {
                            Exito: {
                                TITULO: 'Factura editada',
                                DESCRIPCION: 'Su factura fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Factura no editada',
                                DESCRIPCION: 'Su factura no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaVenta: {
                            Exito: {
                                TITULO: 'Nota de venta editada',
                                DESCRIPCION: 'Su nota de venta fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Nota de venta no editada',
                                DESCRIPCION: 'Su nota de venta no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaCredito: {
                            Exito: {
                                TITULO: 'Nota de crédito editada',
                                DESCRIPCION: 'Su nota de crédito fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Nota de crédito no editada',
                                DESCRIPCION: 'Su nota de crédito no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        },
                        NotaDebito: {
                            Exito: {
                                TITULO: 'Nota de débito editada',
                                DESCRIPCION: 'Su nota de débito fue editada correctamente.'
                            },
                            Fallido: {
                                TITULO: 'Nota de débito no editada',
                                DESCRIPCION: 'Su nota de débito no fue editada, inténtelo más tarde o contáctese con el administrador.'
                            }
                        }
                    },
                    Anular: {
                        DocumentoVenta: {
                            Exito: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: '{0} fue {1} con éxito.'
                            },
                            Fallido: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: '{0} no fue {1}. Contáctese con el administrador o inténtelo más tarde.'
                            }
                        }
                    },
                    Aprobar: {
                        Cotizacion: {
                            Exito: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La cotización fue aprobada con éxito.'
                            },
                            Fallido: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La cotización no fue aprobada. Contáctese con el administrador o inténtelo más tarde.'
                            }
                        },
                        Pedido: {
                            Exito: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'El pedido fue aprobado con éxito.'
                            },
                            Fallido: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'El pedido no fue aprobado. Contáctese con el administrador o inténtelo más tarde.'
                            }
                        }
                    },
                    AnularAprobar: {
                        Cotizacion: {
                            Exito: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La aprobación de la cotización fue anulada con éxito.'
                            },
                            Fallido: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La aprobación de la cotización no fue anulada. Contáctese con el administrador o inténtelo más tarde.'
                            }
                        },
                        Pedido: {
                            Exito: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La aprobación del pedido fue anulada con éxito.'
                            },
                            Fallido: {
                                TITULO: 'Status del documento',
                                DESCRIPCION: 'La aprobación del pedido no fue anulada. Contáctese con el administrador o inténtelo más tarde.'
                            }
                        }
                    },
                    BuscarNotaIngreso: {
                        Fallido: {
                            TITULO: 'No existe Nota de Ingreso',
                            DESCRIPCION: 'La transacción no tiene información en nota de ingreso; por favor generar primero dicho documento'
                        }
                    }
                }
            },
            TipoVenta: {
                MERCADERIA: '01'
            },
            Reportes: {}
        }
    },
    PRIMEROS_DOS_CARACTERES_RUC_NATURAL: '10',
    PRIMEROS_DOS_CARACTERES_RUC_JURIDICO: '20',
    PRIMER_CARACTER_CODIGO_CLIENTE_A: 'C',
    PRIMER_CARACTER_CODIGO_CLIENTE_B: 'K',
    CADENAS_BOOLEANAS: [
        '.t.', '.f.', 'True', 'False'
    ],
    LETRA_INICIAL_TRUE: 't',
    BTN_CREAR_CLIENTE: 'btn-crearCliente',
    BTN_CREAR_CLIENTE_VARIOS: 'btn-registrarComoVarios',
    ElementoHtml: {
        INPUT: 'INPUT',
        SELECT: 'SELECT',
        TD: 'TD',
        SPAN: 'SPAN',
        P: 'P'
    },
    DocumentoVenta: {
        AprobacionFlag: {
            NO_APROBADO: '0',
            APROBADO: '1',
            DESAPROBADO: '2'
        },
        Flag: {
            ATENDIDO: '1',
            ANULADO: '*'
        },
        Cotizacion: {
            CODIGO: '31',
            DESCRIPCION: 'Cotización',
            Estado: {
                NO_APROBADO: '0',
                APROBADO: '3',
                RECHAZADO: '4'
            }
        },
        Pedido: {
            CODIGO: '32',
            DESCRIPCION: 'Pedido'
        },
        Boleta: {
            CODIGO: '03',
            DESCRIPCION: 'Boleta'
        },
        Factura: {
            CODIGO: '01',
            DESCRIPCION: 'Factura'
        },
        NotaVenta: {
            CODIGO: '65',
            DESCRIPCION: 'Nota de Venta'
        },
        NotaDebito: {
            CODIGO: '08',
            DESCRIPCION: 'Nota de Débito'
        },
        NotaCredito: {
            CODIGO: '07',
            DESCRIPCION: 'Nota de Crédito'
        },
        NotaIngreso: {
            //CODIGO: '31',
            DESCRIPCION: 'Nota de Ingreso'
        }
    },
    //TIPO_VENTA_MERCADERIA: '01',

    Moneda: {
        Sol: {
            ID: 1,
            INICIAL: 'S',
            DESCRIPCION: 'Sol',
            DESCRIPCION_PLURAL: 'Soles',
            SIMBOLO: 'S/'
        },
        Dolar: {
            ID: 2,
            INICIAL: 'D',
            DESCRIPCION: 'Dólar',
            DESCRIPCION_PLURAL: 'Dólares',
            SIMBOLO: '$'
        }
    },
    Grafico: {
        LINEAS: 1,
        BARRAS: 2
    },
    //SubModulo
    Ventas: {},
    //Gestion: {},
    TipoQueryReporteVentasAnuales: {
        NORMAL: 1,
        COMPARATIVO: 2,
        COMPARATIVO_CONTADO_CREDITO: 3
    },
    TipoBusquedaProducto: {
        POR_DESCRIPCION: 1,
        POR_CODIGO: 2
    },
    KeyCode: {
        B: 66,
        FLECHA_DERECHA: 39,
        FLECHA_IZQUIERDA: 37,
        G: 71
    },
    CondicionVenta: {
        CONTADO: '01'
    },
    MetodoPago: {
        Efectivo: {
            CODIGO: '01'
        },
        Tarjeta: {
            CODIGO: '02'
        },
        Mixto: {
            CODIGO: '03'
        },
        Credito: {
            CODIGO: '04'
        }
    },
    TablaRankingCompras: {
        Columna: {
            INFO: 'info'
        }
    }
};


var Enumeradores = {
    TipoBusqueda: {
        POR_CODIGO: 1,
        POR_RUC: 2,
        POR_NOMBRE: 3
    },
    EntidadBusqueda: {
        CLIENTE: 1
    },
    InicialMoneda: {
        SOL: "S",
        DOLAR: "D"
    },
    TipoMoneda: {
        SOL: 1,
        DOLAR: 2
    },
    Variable: {
        NUMERICA: 'number',
        CADENA: 'string'
    },
    Notificacion: {
        ALERTA: 1,
        CONFIRMACION: 2,
        ENTRADA: 3
    },
    ColumnaTablaDetalleCotizacion: {
        PRECIO_UNITARIO: 1,
        DESCUENTO: 2,
        SUBTOTAL: 3,
        TOTAL: 4
    },
    NivelUsuario: {
        ADMINISTRADOR: 62
    },
    Operacion: {
        CREAR: 2,
        EDITAR: 3,
        OBTENER: 4
    },
    Documento: {
        COTIZACION: '31',
        PEDIDO: '32',
        FACTURA: '01',
        BOLETA: '03',
        NOTA_VENTA: '65',
        NOTA_CREDITO: '07',
        NOTA_DEBITO: '08'
    },
    Color: {
        VERDE: 1,
        AMARILLO: 2,
        ROJO: 3
    },
    CondicionVenta: {
        CONTADO: '01'
    },
    Genero: {
        MASCULINO: 1,
        FEMENINO: 2
    },
    EstadoDocumentoVenta: {
        DESAPROBADO: 0
    }
};
